/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.effects;

import dev.xkmc.fruitsdelight.content.effects.RangeSearchEffect;
import dev.xkmc.l2library.base.effects.api.ClientRenderEffect;
import dev.xkmc.l2library.base.effects.api.DelayedEntityRender;
import dev.xkmc.l2library.base.effects.api.FirstPlayerRenderEffect;
import dev.xkmc.l2library.util.Proxy;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class RangeRenderEffect
extends RangeSearchEffect
implements ClientRenderEffect,
FirstPlayerRenderEffect {
    protected RangeRenderEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void render(LivingEntity entity, int lv, Consumer<DelayedEntityRender> consumer) {
        if (entity == Proxy.getClientPlayer()) {
            return;
        }
        this.renderEffect(lv, (Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientLevelRender(AbstractClientPlayer player, MobEffectInstance ins) {
        this.renderEffect(ins.m_19564_(), (Entity)player);
    }

    private void renderEffect(int lv, Entity entity) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        int r = this.getRange();
        int count = this.getParticleCount(lv);
        for (int i = 0; i < count; ++i) {
            this.addParticle(entity.m_9236_(), entity.m_20182_().m_82520_(0.0, (double)(entity.m_20192_() / 2.0f), 0.0), r);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addParticle(Level w, Vec3 vec, int r) {
        float tpi = (float)Math.PI * 2;
        Vec3 v0 = new Vec3(0.0, (double)r, 0.0);
        v0 = v0.m_82496_(tpi / 4.0f).m_82524_(w.m_213780_().m_188501_() * tpi);
        w.m_7107_(this.getParticle(), vec.f_82479_ + v0.f_82479_, vec.f_82480_ + v0.f_82480_, vec.f_82481_ + v0.f_82481_, 0.0, 0.0, 0.0);
    }

    protected abstract int getParticleCount(int var1);

    protected abstract ParticleOptions getParticle();
}

